# Generated by configen, do not edit.
# See https://github.com/facebookresearch/hydra/tree/master/tools/configen
# fmt: off
# isort:skip_file
# flake8: noqa

from dataclasses import dataclass, field
from conduit.data.datasets.vision.camelyon17 import Camelyon17Attr
from conduit.data.datasets.vision.camelyon17 import Camelyon17Split
from conduit.data.datasets.vision.camelyon17 import Camelyon17SplitScheme
from conduit.data.datasets.vision.celeba import CelebASplit
from conduit.data.datasets.vision.celeba import CelebAttr
from conduit.data.datasets.vision.isic import IsicAttr
from conduit.data.datasets.vision.nico import NicoSuperclass
from conduit.data.datasets.vision.ssrp import SSRPSplit
from conduit.data.datasets.vision.waterbirds.waterbirds import WaterbirdsSplit
from omegaconf import MISSING
from pathlib import Path
from typing import Any
from typing import List
from typing import Optional
from typing import Union


@dataclass
class CelebAConf:
    _target_: str = "conduit.data.datasets.vision.CelebA"
    root: Union[str, Path] = MISSING
    download: bool = True
    superclass: Union[CelebAttr, str] = CelebAttr.SMILING
    subclass: Union[CelebAttr, str] = CelebAttr.MALE
    transform: Any = None  # Optional[Union[Compose, BasicTransform, Callable[[Image], Any]]]
    split: Optional[Union[CelebASplit, str]] = None


@dataclass
class ColoredMNISTConf:
    _target_: str = "conduit.data.datasets.vision.ColoredMNIST"
    root: Union[str, Path] = MISSING
    download: bool = True
    transform: Any = None  # Optional[Union[Compose, BasicTransform, Callable[[Image], Any]]]
    label_map: Any = None  # Optional[Dict[int, int]]
    colors: Optional[List[int]] = None
    num_colors: int = 10
    scale: float = 0.2
    correlation: Optional[float] = None
    binarize: bool = False
    greyscale: bool = False
    background: bool = False
    black: bool = True
    split: Any = None  # Optional[Union[ColoredMNISTSplit, str, List[int]]]
    seed: Optional[int] = 42


@dataclass
class ISICConf:
    _target_: str = "conduit.data.datasets.vision.ISIC"
    root: Union[str, Path] = MISSING
    download: bool = True
    max_samples: int = 25000
    target_attr: IsicAttr = IsicAttr.MALIGNANT
    context_attr: IsicAttr = IsicAttr.HISTO
    transform: Any = None  # Optional[Union[Compose, BasicTransform, Callable[[Image], Any]]]


@dataclass
class NICOConf:
    _target_: str = "conduit.data.datasets.vision.NICO"
    root: Union[str, Path] = MISSING
    download: bool = True
    transform: Any = None  # Optional[Union[Compose, BasicTransform, Callable[[Image], Any]]]
    superclass: Optional[Union[NicoSuperclass, str]] = NicoSuperclass.ANIMALS


@dataclass
class SSRPConf:
    _target_: str = "conduit.data.datasets.vision.SSRP"
    root: Union[str, Path] = MISSING
    split: Union[SSRPSplit, str] = SSRPSplit.PRETRAIN
    download: bool = True
    transform: Any = None  # Optional[Union[Compose, BasicTransform, Callable[[Image], Any]]]


@dataclass
class WaterbirdsConf:
    _target_: str = "conduit.data.datasets.vision.Waterbirds"
    root: Union[str, Path] = MISSING
    download: bool = True
    transform: Any = None  # Optional[Union[Compose, BasicTransform, Callable[[Image], Any]]]
    split: Optional[Union[WaterbirdsSplit, str]] = None
    fixed: bool = False


@dataclass
class Camelyon17Conf:
    _target_: str = "conduit.data.datasets.vision.Camelyon17"
    root: Union[str, Path] = MISSING
    download: bool = True
    transform: Any = None  # Optional[Union[Compose, BasicTransform, Callable[[Image], Any]]]
    split: Optional[Union[Camelyon17Split, str]] = None
    split_scheme: Union[Camelyon17SplitScheme, str] = Camelyon17SplitScheme.OFFICIAL
    superclass: Union[Camelyon17Attr, str] = Camelyon17Attr.TUMOR
    subclass: Union[Camelyon17Attr, str] = Camelyon17Attr.CENTER
